@extends('components.layouts.admin')

@section('title', 'KYC Analytics')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">KYC Analytics</h1>
            <p class="text-gray-600">KYC submission trends, processing metrics, and compliance insights</p>
        </div>
        <div class="flex space-x-3">
            <flux:select id="period-select" onchange="updatePeriod(this.value)">
                <option value="7d" {{ $period === '7d' ? 'selected' : '' }}>Last 7 Days</option>
                <option value="30d" {{ $period === '30d' ? 'selected' : '' }}>Last 30 Days</option>
                <option value="90d" {{ $period === '90d' ? 'selected' : '' }}>Last 90 Days</option>
                <option value="1y" {{ $period === '1y' ? 'selected' : '' }}>Last Year</option>
            </flux:select>
            <flux:button href="{{ route('admin.analytics.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Analytics
            </flux:button>
        </div>
    </div>

    <!-- KYC Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="identification" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Documents</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($kycProcessing['total_documents']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="clock" class="w-8 h-8 text-yellow-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Pending</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($kycProcessing['pending_documents']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="check-circle" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Approved</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($kycProcessing['approved_documents']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="x-circle" class="w-8 h-8 text-red-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Rejected</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($kycProcessing['rejected_documents']) }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Processing Metrics -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <flux:card>
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500">Approval Rate</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $kycProcessing['approval_rate'] }}%</p>
                </div>
                <flux:icon name="chart-pie" class="w-12 h-12 text-green-600" />
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500">Avg Processing Time</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $kycProcessing['average_processing_time'] }}h</p>
                </div>
                <flux:icon name="clock" class="w-12 h-12 text-blue-600" />
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- KYC Submission Trend -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">KYC Submission Trend</flux:heading>
            @if($kycSubmission->count() > 0)
                <div class="space-y-3">
                    @foreach($kycSubmission as $data)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ \Carbon\Carbon::parse($data->date)->format('M j, Y') }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-blue-600 h-2 rounded-full" style="width: {{ ($data->count / $kycSubmission->max('count')) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $data->count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No KYC submission data available for the selected period.</p>
            @endif
        </flux:card>

        <!-- Document Type Distribution -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Document Type Distribution</flux:heading>
            @if($kycProcessing['by_type']->count() > 0)
                <div class="space-y-3">
                    @foreach($kycProcessing['by_type'] as $type => $count)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ ucfirst(str_replace('_', ' ', $type)) }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-purple-600 h-2 rounded-full" style="width: {{ ($count / $kycProcessing['by_type']->sum()) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No document type data available.</p>
            @endif
        </flux:card>
    </div>

    <!-- Status Analysis -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">KYC Status Analysis</flux:heading>
        @if($kycProcessing['by_status']->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($kycProcessing['by_status'] as $status => $count)
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <div class="flex justify-between items-center mb-2">
                            <span class="text-sm font-medium text-gray-900">
                                {{ ucfirst(str_replace('_', ' ', $status)) }}
                            </span>
                            <span class="text-xs text-gray-500">{{ $count }} docs</span>
                        </div>
                        <div class="text-2xl font-bold text-gray-900 mb-1">
                            {{ $kycProcessing['total_documents'] > 0 ? number_format(($count / $kycProcessing['total_documents']) * 100, 1) : 0 }}%
                        </div>
                        <div class="text-sm text-gray-500">
                            of total documents
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500">No KYC status data available.</p>
        @endif
    </flux:card>

    <!-- Processing Performance -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Processing Efficiency -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Processing Efficiency</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Total Documents</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($kycProcessing['total_documents']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Processed Documents</span>
                    <span class="text-lg font-semibold text-gray-900">
                        {{ number_format($kycProcessing['approved_documents'] + $kycProcessing['rejected_documents']) }}
                    </span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Processing Rate</span>
                    <span class="text-lg font-semibold text-gray-900">
                        {{ $kycProcessing['total_documents'] > 0 ? number_format((($kycProcessing['approved_documents'] + $kycProcessing['rejected_documents']) / $kycProcessing['total_documents']) * 100, 1) : 0 }}%
                    </span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Average Processing Time</span>
                    <span class="text-lg font-semibold text-gray-900">{{ $kycProcessing['average_processing_time'] }} hours</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Approval Rate</span>
                    <span class="text-lg font-semibold text-gray-900">{{ $kycProcessing['approval_rate'] }}%</span>
                </div>
            </div>
        </flux:card>

        <!-- Submission Trends -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Submission Trends</flux:heading>
            @if($kycSubmission->count() > 0)
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div class="text-center p-3 bg-gray-50 rounded-lg">
                            <div class="text-xl font-bold text-gray-900">{{ $kycSubmission->sum('count') }}</div>
                            <div class="text-xs text-gray-500">Total ({{ ucfirst($period) }})</div>
                        </div>
                        <div class="text-center p-3 bg-gray-50 rounded-lg">
                            <div class="text-xl font-bold text-gray-900">
                                {{ number_format($kycSubmission->avg('count'), 1) }}
                            </div>
                            <div class="text-xs text-gray-500">Daily Average</div>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <h4 class="text-sm font-medium text-gray-700 mb-3">Recent Activity</h4>
                        <div class="space-y-2">
                            @foreach($kycSubmission->take(7) as $data)
                                <div class="flex justify-between items-center">
                                    <span class="text-sm text-gray-600">
                                        {{ \Carbon\Carbon::parse($data->date)->format('M j') }}
                                    </span>
                                    <div class="flex items-center space-x-2">
                                        <div class="w-20 bg-gray-200 rounded-full h-1">
                                            <div class="bg-blue-600 h-1 rounded-full" style="width: {{ ($data->count / $kycSubmission->max('count')) * 100 }}%"></div>
                                        </div>
                                        <span class="text-xs text-gray-500 w-6 text-right">{{ $data->count }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @else
                <p class="text-sm text-gray-500">No submission trend data available for the selected period.</p>
            @endif
        </flux:card>
    </div>

    <!-- Compliance Status -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Compliance Status Overview</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center p-4 bg-green-50 rounded-lg">
                <div class="text-2xl font-bold text-green-600">{{ $kycProcessing['approved_documents'] }}</div>
                <div class="text-sm text-green-700">Approved Documents</div>
                <div class="text-xs text-green-600 mt-1">
                    {{ $kycProcessing['total_documents'] > 0 ? number_format(($kycProcessing['approved_documents'] / $kycProcessing['total_documents']) * 100, 1) : 0 }}% of total
                </div>
            </div>
            <div class="text-center p-4 bg-yellow-50 rounded-lg">
                <div class="text-2xl font-bold text-yellow-600">{{ $kycProcessing['pending_documents'] }}</div>
                <div class="text-sm text-yellow-700">Pending Review</div>
                <div class="text-xs text-yellow-600 mt-1">
                    {{ $kycProcessing['total_documents'] > 0 ? number_format(($kycProcessing['pending_documents'] / $kycProcessing['total_documents']) * 100, 1) : 0 }}% of total
                </div>
            </div>
            <div class="text-center p-4 bg-red-50 rounded-lg">
                <div class="text-2xl font-bold text-red-600">{{ $kycProcessing['rejected_documents'] }}</div>
                <div class="text-sm text-red-700">Rejected Documents</div>
                <div class="text-xs text-red-600 mt-1">
                    {{ $kycProcessing['total_documents'] > 0 ? number_format(($kycProcessing['rejected_documents'] / $kycProcessing['total_documents']) * 100, 1) : 0 }}% of total
                </div>
            </div>
        </div>
    </flux:card>
</div>

<script>
function updatePeriod(period) {
    const url = new URL(window.location);
    url.searchParams.set('period', period);
    window.location.href = url.toString();
}
</script>
@endsection
