@extends('components.layouts.admin')

@section('title', 'Analytics Dashboard')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Analytics Dashboard</h1>
            <p class="text-gray-600">Real-time insights and performance metrics</p>
        </div>
        <div class="flex space-x-3">
            <flux:select id="period-select" onchange="updatePeriod(this.value)">
                <option value="7d" {{ $period === '7d' ? 'selected' : '' }}>Last 7 Days</option>
                <option value="30d" {{ $period === '30d' ? 'selected' : '' }}>Last 30 Days</option>
                <option value="90d" {{ $period === '90d' ? 'selected' : '' }}>Last 90 Days</option>
                <option value="1y" {{ $period === '1y' ? 'selected' : '' }}>Last Year</option>
            </flux:select>
            <flux:button onclick="refreshData()" variant="outline" class="text-xs">
                <flux:icon name="arrow-path" class="w-4 h-4 mr-2" />
                Refresh
            </flux:button>
        </div>
    </div>

    <!-- Real-time Metrics -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
        <!-- Users Today -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="users" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Users Today</p>
                    <p class="text-2xl font-semibold text-gray-900" id="users-today">{{ number_format($realTimeMetrics['users']['today']) }}</p>
                    <p class="text-xs text-gray-500">
                        <span id="users-today-change" class="{{ $realTimeMetrics['users']['today'] >= $realTimeMetrics['users']['yesterday'] ? 'text-green-600' : 'text-red-600' }}">
                            {{ $realTimeMetrics['users']['today'] >= $realTimeMetrics['users']['yesterday'] ? '+' : '' }}{{ $realTimeMetrics['users']['today'] - $realTimeMetrics['users']['yesterday'] }}
                        </span>
                        vs yesterday
                    </p>
                </div>
            </div>
        </flux:card>

        <!-- Transactions Today -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="arrow-path" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Transactions Today</p>
                    <p class="text-2xl font-semibold text-gray-900" id="transactions-today">{{ number_format($realTimeMetrics['transactions']['today']) }}</p>
                    <p class="text-xs text-gray-500">
                        <span id="transactions-today-change" class="{{ $realTimeMetrics['transactions']['today'] >= $realTimeMetrics['transactions']['yesterday'] ? 'text-green-600' : 'text-red-600' }}">
                            {{ $realTimeMetrics['transactions']['today'] >= $realTimeMetrics['transactions']['yesterday'] ? '+' : '' }}{{ $realTimeMetrics['transactions']['today'] - $realTimeMetrics['transactions']['yesterday'] }}
                        </span>
                        vs yesterday
                    </p>
                </div>
            </div>
        </flux:card>

        <!-- Accounts Today -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="credit-card" class="w-8 h-8 text-purple-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Accounts Today</p>
                    <p class="text-2xl font-semibold text-gray-900" id="accounts-today">{{ number_format($realTimeMetrics['accounts']['today']) }}</p>
                    <p class="text-xs text-gray-500">
                        <span id="accounts-today-change" class="{{ $realTimeMetrics['accounts']['today'] >= $realTimeMetrics['accounts']['yesterday'] ? 'text-green-600' : 'text-red-600' }}">
                            {{ $realTimeMetrics['accounts']['today'] >= $realTimeMetrics['accounts']['yesterday'] ? '+' : '' }}{{ $realTimeMetrics['accounts']['today'] - $realTimeMetrics['accounts']['yesterday'] }}
                        </span>
                        vs yesterday
                    </p>
                </div>
            </div>
        </flux:card>

        <!-- KYC Today -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="identification" class="w-8 h-8 text-orange-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">KYC Today</p>
                    <p class="text-2xl font-semibold text-gray-900" id="kyc-today">{{ number_format($realTimeMetrics['kyc']['today']) }}</p>
                    <p class="text-xs text-gray-500">
                        <span id="kyc-today-change" class="{{ $realTimeMetrics['kyc']['today'] >= $realTimeMetrics['kyc']['yesterday'] ? 'text-green-600' : 'text-red-600' }}">
                            {{ $realTimeMetrics['kyc']['today'] >= $realTimeMetrics['kyc']['yesterday'] ? '+' : '' }}{{ $realTimeMetrics['kyc']['today'] - $realTimeMetrics['kyc']['yesterday'] }}
                        </span>
                        vs yesterday
                    </p>
                </div>
            </div>
        </flux:card>

        <!-- Compliance Today -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="exclamation-triangle" class="w-8 h-8 text-red-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Compliance Today</p>
                    <p class="text-2xl font-semibold text-gray-900" id="compliance-today">{{ number_format($realTimeMetrics['compliance']['today']) }}</p>
                    <p class="text-xs text-gray-500">
                        <span id="compliance-today-change" class="{{ $realTimeMetrics['compliance']['today'] >= $realTimeMetrics['compliance']['yesterday'] ? 'text-red-600' : 'text-green-600' }}">
                            {{ $realTimeMetrics['compliance']['today'] >= $realTimeMetrics['compliance']['yesterday'] ? '+' : '' }}{{ $realTimeMetrics['compliance']['today'] - $realTimeMetrics['compliance']['yesterday'] }}
                        </span>
                        vs yesterday
                    </p>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Key Performance Indicators -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- User Activity Summary -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">User Activity Summary</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Total Users</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($userActivity['total_users']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Active Users</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($userActivity['active_users']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">New Users ({{ ucfirst($period) }})</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($userActivity['new_users']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Growth Rate</span>
                    <span class="text-lg font-semibold {{ $userActivity['user_growth_rate'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                        {{ $userActivity['user_growth_rate'] >= 0 ? '+' : '' }}{{ $userActivity['user_growth_rate'] }}%
                    </span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">User Retention</span>
                    <span class="text-lg font-semibold text-gray-900">{{ $userActivity['user_retention'] }}%</span>
                </div>
            </div>
        </flux:card>

        <!-- Transaction Summary -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Transaction Summary</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Total Transactions</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($transactionTrends['total_transactions']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Period Transactions</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($transactionTrends['period_transactions']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Total Volume</span>
                    <span class="text-lg font-semibold text-gray-900">${{ number_format($transactionTrends['total_volume'], 2) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Period Volume</span>
                    <span class="text-lg font-semibold text-gray-900">${{ number_format($transactionTrends['period_volume'], 2) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Average Transaction</span>
                    <span class="text-lg font-semibold text-gray-900">${{ number_format($transactionTrends['average_transaction'], 2) }}</span>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Account Performance -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Account Performance</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="text-center">
                <div class="text-2xl font-bold text-gray-900">{{ number_format($accountPerformance['total_accounts']) }}</div>
                <div class="text-sm text-gray-500">Total Accounts</div>
            </div>
            <div class="text-center">
                <div class="text-2xl font-bold text-green-600">{{ number_format($accountPerformance['active_accounts']) }}</div>
                <div class="text-sm text-gray-500">Active Accounts</div>
            </div>
            <div class="text-center">
                <div class="text-2xl font-bold text-yellow-600">{{ number_format($accountPerformance['suspended_accounts']) }}</div>
                <div class="text-sm text-gray-500">Suspended</div>
            </div>
            <div class="text-center">
                <div class="text-2xl font-bold text-red-600">{{ number_format($accountPerformance['closed_accounts']) }}</div>
                <div class="text-sm text-gray-500">Closed</div>
            </div>
        </div>
        <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <div class="text-sm font-medium text-gray-700 mb-2">Total Balance</div>
                <div class="text-2xl font-bold text-gray-900">${{ number_format($accountPerformance['total_balance'], 2) }}</div>
            </div>
            <div>
                <div class="text-sm font-medium text-gray-700 mb-2">Average Balance</div>
                <div class="text-2xl font-bold text-gray-900">${{ number_format($accountPerformance['average_balance'], 2) }}</div>
            </div>
        </div>
    </flux:card>

    <!-- KYC & Compliance Status -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- KYC Processing -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">KYC Processing</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Total Documents</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($kycProcessing['total_documents']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Pending</span>
                    <span class="text-lg font-semibold text-yellow-600">{{ number_format($kycProcessing['pending_documents']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Approved</span>
                    <span class="text-lg font-semibold text-green-600">{{ number_format($kycProcessing['approved_documents']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Rejected</span>
                    <span class="text-lg font-semibold text-red-600">{{ number_format($kycProcessing['rejected_documents']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Approval Rate</span>
                    <span class="text-lg font-semibold text-gray-900">{{ $kycProcessing['approval_rate'] }}%</span>
                </div>
            </div>
        </flux:card>

        <!-- Compliance Monitoring -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Compliance Monitoring</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Total Logs</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($complianceMonitoring['total_logs']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Pending</span>
                    <span class="text-lg font-semibold text-yellow-600">{{ number_format($complianceMonitoring['pending_logs']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Critical Issues</span>
                    <span class="text-lg font-semibold text-red-600">{{ number_format($complianceMonitoring['critical_issues']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">High Priority</span>
                    <span class="text-lg font-semibold text-orange-600">{{ number_format($complianceMonitoring['high_priority']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Under Review</span>
                    <span class="text-lg font-semibold text-blue-600">{{ number_format($complianceMonitoring['under_review']) }}</span>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Quick Navigation -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Detailed Analytics</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <flux:button href="{{ route('admin.analytics.users') }}" variant="outline" class="w-full">
                <flux:icon name="users" class="w-4 h-4 mr-2" />
                User Analytics
            </flux:button>
            <flux:button href="{{ route('admin.analytics.transactions') }}" variant="outline" class="w-full">
                <flux:icon name="arrow-path" class="w-4 h-4 mr-2" />
                Transaction Analytics
            </flux:button>
            <flux:button href="{{ route('admin.analytics.accounts') }}" variant="outline" class="w-full">
                <flux:icon name="credit-card" class="w-4 h-4 mr-2" />
                Account Analytics
            </flux:button>
            <flux:button href="{{ route('admin.analytics.kyc') }}" variant="outline" class="w-full">
                <flux:icon name="identification" class="w-4 h-4 mr-2" />
                KYC Analytics
            </flux:button>
        </div>
    </flux:card>
</div>

<script>
function updatePeriod(period) {
    const url = new URL(window.location);
    url.searchParams.set('period', period);
    window.location.href = url.toString();
}

function refreshData() {
    // Refresh real-time metrics
    fetch('{{ route("admin.analytics.api.real-time-metrics") }}')
        .then(response => response.json())
        .then(data => {
            updateRealTimeMetrics(data);
        })
        .catch(error => console.error('Error refreshing data:', error));
}

function updateRealTimeMetrics(data) {
    // Update users today
    document.getElementById('users-today').textContent = data.users.today.toLocaleString();
    const usersChange = data.users.today - data.users.yesterday;
    const usersChangeEl = document.getElementById('users-today-change');
    usersChangeEl.textContent = (usersChange >= 0 ? '+' : '') + usersChange;
    usersChangeEl.className = usersChange >= 0 ? 'text-green-600' : 'text-red-600';

    // Update transactions today
    document.getElementById('transactions-today').textContent = data.transactions.today.toLocaleString();
    const transactionsChange = data.transactions.today - data.transactions.yesterday;
    const transactionsChangeEl = document.getElementById('transactions-today-change');
    transactionsChangeEl.textContent = (transactionsChange >= 0 ? '+' : '') + transactionsChange;
    transactionsChangeEl.className = transactionsChange >= 0 ? 'text-green-600' : 'text-red-600';

    // Update accounts today
    document.getElementById('accounts-today').textContent = data.accounts.today.toLocaleString();
    const accountsChange = data.accounts.today - data.accounts.yesterday;
    const accountsChangeEl = document.getElementById('accounts-today-change');
    accountsChangeEl.textContent = (accountsChange >= 0 ? '+' : '') + accountsChange;
    accountsChangeEl.className = accountsChange >= 0 ? 'text-green-600' : 'text-red-600';

    // Update KYC today
    document.getElementById('kyc-today').textContent = data.kyc.today.toLocaleString();
    const kycChange = data.kyc.today - data.kyc.yesterday;
    const kycChangeEl = document.getElementById('kyc-today-change');
    kycChangeEl.textContent = (kycChange >= 0 ? '+' : '') + kycChange;
    kycChangeEl.className = kycChange >= 0 ? 'text-green-600' : 'text-red-600';

    // Update compliance today
    document.getElementById('compliance-today').textContent = data.compliance.today.toLocaleString();
    const complianceChange = data.compliance.today - data.compliance.yesterday;
    const complianceChangeEl = document.getElementById('compliance-today-change');
    complianceChangeEl.textContent = (complianceChange >= 0 ? '+' : '') + complianceChange;
    complianceChangeEl.className = complianceChange >= 0 ? 'text-red-600' : 'text-green-600';
}

// Auto-refresh every 30 seconds
setInterval(refreshData, 30000);
</script>
@endsection
