@extends('components.layouts.admin')

@section('title', 'Account Details - ' . $account->account_name)

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Account Details</h1>
                <p class="text-gray-600">View and manage account information</p>
            </div>
            <div class="flex space-x-3">
                <flux:button href="{{ route('admin.accounts.edit', $account) }}" variant="primary">
                    <flux:icon name="pencil" class="w-4 h-4 mr-2" />
                    Edit Account
                </flux:button>
                <flux:button href="{{ route('admin.accounts.index') }}" variant="outline">
                    <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                    Back to Accounts
                </flux:button>
            </div>
        </div>

        <!-- Account Overview -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                        <flux:icon name="credit-card" class="w-6 h-6 text-blue-600" />
                    </div>
                    <div>
                        <h2 class="text-xl font-semibold text-gray-900">{{ $account->account_name }}</h2>
                        <p class="text-gray-600">{{ $account->account_number }}</p>
                    </div>
                </div>
                <div class="flex items-center space-x-3">
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                        @if($account->status === 'active') bg-green-100 text-green-800
                        @elseif($account->status === 'suspended') bg-red-100 text-red-800
                        @elseif($account->status === 'frozen') bg-yellow-100 text-yellow-800
                        @elseif($account->status === 'closed') bg-gray-100 text-gray-800
                        @else bg-blue-100 text-blue-800
                        @endif">
                        {{ $account->account_status_label }}
                    </span>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                        @if($account->verification_status === 'verified') bg-green-100 text-green-800
                        @elseif($account->verification_status === 'rejected') bg-red-100 text-red-800
                        @else bg-yellow-100 text-yellow-800
                        @endif">
                        {{ $account->verification_status_label }}
                    </span>
                    @if($account->is_master_account)
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                            Master Account
                        </span>
                    @endif
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Balance Information -->
                <div class="bg-gray-50 rounded-lg p-4">
                    <h3 class="text-sm font-medium text-gray-500 mb-2">Current Balance</h3>
                    <p class="text-2xl font-bold text-gray-900">{{ $account->currency_symbol }}{{ number_format($account->balance, 2) }}</p>
                    <p class="text-sm text-gray-600 mt-1">Available: {{ $account->currency_symbol }}{{ number_format($account->available_balance, 2) }}</p>
                    @if($account->hold_balance > 0)
                        <p class="text-sm text-gray-600">On Hold: {{ $account->currency_symbol }}{{ number_format($account->hold_balance, 2) }}</p>
                    @endif
                </div>

                <!-- Account Type -->
                <div class="bg-gray-50 rounded-lg p-4">
                    <h3 class="text-sm font-medium text-gray-500 mb-2">Account Type</h3>
                    <p class="text-lg font-semibold text-gray-900">{{ ucfirst($account->account_type) }}</p>
                    <p class="text-sm text-gray-600">{{ $account->currency }}</p>
                </div>

                <!-- Risk Level -->
                <div class="bg-gray-50 rounded-lg p-4">
                    <h3 class="text-sm font-medium text-gray-500 mb-2">Risk Level</h3>
                    <span class="inline-flex items-center px-2 py-1 rounded-full text-sm font-medium
                        @if($account->risk_level === 'low') bg-green-100 text-green-800
                        @elseif($account->risk_level === 'medium') bg-yellow-100 text-yellow-800
                        @else bg-red-100 text-red-800
                        @endif">
                        {{ ucfirst($account->risk_level) }}
                    </span>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Account Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Information</h3>
                <dl class="space-y-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Account Number</dt>
                        <dd class="text-sm text-gray-900 font-mono">{{ $account->account_number }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Account Name</dt>
                        <dd class="text-sm text-gray-900">{{ $account->account_name }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Description</dt>
                        <dd class="text-sm text-gray-900">{{ $account->description ?: 'No description' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Currency</dt>
                        <dd class="text-sm text-gray-900">{{ $account->currency }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Interest Rate</dt>
                        <dd class="text-sm text-gray-900">{{ $account->interest_rate ? ($account->interest_rate * 100) . '%' : 'N/A' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Interest Frequency</dt>
                        <dd class="text-sm text-gray-900">{{ $account->interest_frequency ? ucfirst($account->interest_frequency) : 'N/A' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Monthly Maintenance Fee</dt>
                        <dd class="text-sm text-gray-900">{{ $account->monthly_maintenance_fee ? $account->currency_symbol . number_format($account->monthly_maintenance_fee, 2) : 'N/A' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Overdraft Limit</dt>
                        <dd class="text-sm text-gray-900">{{ $account->overdraft_limit ? $account->currency_symbol . number_format($account->overdraft_limit, 2) : 'N/A' }}</dd>
                    </div>
                </dl>
            </div>

            <!-- User Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Holder</h3>
                <dl class="space-y-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Name</dt>
                        <dd class="text-sm text-gray-900">{{ $account->user->name }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Email</dt>
                        <dd class="text-sm text-gray-900">{{ $account->user->email }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Customer ID</dt>
                        <dd class="text-sm text-gray-900 font-mono">{{ $account->user->customer_id }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Customer Type</dt>
                        <dd class="text-sm text-gray-900">{{ ucfirst($account->user->customer_type) }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Customer Status</dt>
                        <dd class="text-sm text-gray-900">{{ ucfirst($account->user->customer_status) }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Actions</dt>
                        <dd class="text-sm text-gray-900">
                            <flux:button href="{{ route('admin.users.show', $account->user) }}" variant="outline" size="sm">
                                View User Profile
                            </flux:button>
                        </dd>
                    </div>
                </dl>
            </div>
        </div>

        <!-- Limits and Features -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Transaction Limits -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Transaction Limits</h3>
                <dl class="space-y-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Daily Transfer Limit</dt>
                        <dd class="text-sm text-gray-900">{{ $account->daily_transfer_limit ? $account->currency_symbol . number_format($account->daily_transfer_limit, 2) : 'Unlimited' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Monthly Transfer Limit</dt>
                        <dd class="text-sm text-gray-900">{{ $account->monthly_transfer_limit ? $account->currency_symbol . number_format($account->monthly_transfer_limit, 2) : 'Unlimited' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Daily Withdrawal Limit</dt>
                        <dd class="text-sm text-gray-900">{{ $account->daily_withdrawal_limit ? $account->currency_symbol . number_format($account->daily_withdrawal_limit, 2) : 'Unlimited' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Monthly Withdrawal Limit</dt>
                        <dd class="text-sm text-gray-900">{{ $account->monthly_withdrawal_limit ? $account->currency_symbol . number_format($account->monthly_withdrawal_limit, 2) : 'Unlimited' }}</dd>
                    </div>
                </dl>
            </div>

            <!-- Account Features -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Features</h3>
                <dl class="space-y-3">
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">Online Banking</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->online_banking_enabled ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->online_banking_enabled ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">Mobile Banking</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->mobile_banking_enabled ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->mobile_banking_enabled ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">Debit Card</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->debit_card_enabled ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->debit_card_enabled ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">Credit Card</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->credit_card_enabled ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->credit_card_enabled ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">International Transfers</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->international_transfers_enabled ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->international_transfers_enabled ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">Investment Trading</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->investment_trading_enabled ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->investment_trading_enabled ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">Two-Factor Authentication</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->two_factor_required ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->two_factor_required ? 'Required' : 'Optional' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">Biometric Authentication</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->biometric_required ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->biometric_required ? 'Required' : 'Optional' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-500">AML Monitoring</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->aml_monitoring_enabled ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $account->aml_monitoring_enabled ? 'Enabled' : 'Disabled' }}
                        </span>
                    </div>
                </dl>
            </div>
        </div>

        <!-- Business Information (if applicable) -->
        @if($account->account_type === 'business' && ($account->business_name || $account->business_type))
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Business Information</h3>
                <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @if($account->business_name)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Business Name</dt>
                            <dd class="text-sm text-gray-900">{{ $account->business_name }}</dd>
                        </div>
                    @endif
                    @if($account->business_type)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Business Type</dt>
                            <dd class="text-sm text-gray-900">{{ $account->business_type }}</dd>
                        </div>
                    @endif
                    @if($account->business_registration_number)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Registration Number</dt>
                            <dd class="text-sm text-gray-900 font-mono">{{ $account->business_registration_number }}</dd>
                        </div>
                    @endif
                    @if($account->tax_identification_number)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Tax ID</dt>
                            <dd class="text-sm text-gray-900 font-mono">{{ $account->tax_identification_number }}</dd>
                        </div>
                    @endif
                </dl>
            </div>
        @endif

        <!-- Investment Information (if applicable) -->
        @if($account->account_type === 'investment' && ($account->investment_strategy || $account->risk_tolerance))
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Investment Information</h3>
                <dl class="space-y-4">
                    @if($account->investment_strategy)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Investment Strategy</dt>
                            <dd class="text-sm text-gray-900">{{ $account->investment_strategy }}</dd>
                        </div>
                    @endif
                    @if($account->risk_tolerance)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Risk Tolerance</dt>
                            <dd class="text-sm text-gray-900">{{ ucfirst($account->risk_tolerance) }}</dd>
                        </div>
                    @endif
                </dl>
            </div>
        @endif

        <!-- Account Timeline -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Timeline</h3>
            <dl class="space-y-4">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Created</dt>
                    <dd class="text-sm text-gray-900">{{ $account->created_at->format('M d, Y \a\t g:i A') }}</dd>
                </div>
                @if($account->activated_at)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Activated</dt>
                        <dd class="text-sm text-gray-900">{{ $account->activated_at->format('M d, Y \a\t g:i A') }}</dd>
                    </div>
                @endif
                @if($account->closed_at)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Closed</dt>
                        <dd class="text-sm text-gray-900">{{ $account->closed_at->format('M d, Y \a\t g:i A') }}</dd>
                    </div>
                @endif
                @if($account->last_risk_assessment)
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Last Risk Assessment</dt>
                        <dd class="text-sm text-gray-900">{{ $account->last_risk_assessment->format('M d, Y \a\t g:i A') }}</dd>
                    </div>
                @endif
            </dl>
        </div>

        <!-- Recent Transactions -->
        @if($account->recentTransactions->count() > 0)
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Recent Transactions</h3>
                    <flux:button href="#" variant="outline" size="sm">
                        View All Transactions
                    </flux:button>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($account->recentTransactions as $transaction)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $transaction->created_at->format('M d, Y') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ ucfirst($transaction->type) }}
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-900">
                                        {{ $transaction->description ?: 'No description' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium
                                        {{ $transaction->type === 'credit' ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $transaction->type === 'credit' ? '+' : '-' }}{{ $account->currency_symbol }}{{ number_format($transaction->amount, 2) }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                            @if($transaction->status === 'completed') bg-green-100 text-green-800
                                            @elseif($transaction->status === 'pending') bg-yellow-100 text-yellow-800
                                            @elseif($transaction->status === 'failed') bg-red-100 text-red-800
                                            @else bg-gray-100 text-gray-800
                                            @endif">
                                            {{ ucfirst($transaction->status) }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif
    </div>
@endsection
