@extends('components.layouts.admin')

@section('title', 'Accounts Management')

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Accounts Management</h1>
                <p class="text-gray-600">Manage all bank accounts and their settings</p>
            </div>
            <flux:button icon="plus" href="{{ route('admin.accounts.create') }}" variant="primary">
                Create Account
            </flux:button>
        </div>

        <!-- Filters -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <form method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <!-- Search -->
                <flux:field>
                    <flux:label>Search</flux:label>
                    <flux:input 
                        name="search" 
                        value="{{ request('search') }}" 
                        placeholder="Account number, name, or user..."
                    />
                </flux:field>

                <!-- Status -->
                <flux:field>
                    <flux:label>Status</flux:label>
                    <flux:select name="status">
                        <option value="">All Statuses</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="suspended" {{ request('status') === 'suspended' ? 'selected' : '' }}>Suspended</option>
                        <option value="frozen" {{ request('status') === 'frozen' ? 'selected' : '' }}>Frozen</option>
                        <option value="closed" {{ request('status') === 'closed' ? 'selected' : '' }}>Closed</option>
                        <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                    </flux:select>
                </flux:field>

                <!-- Account Type -->
                <flux:field>
                    <flux:label>Account Type</flux:label>
                    <flux:select name="account_type">
                        <option value="">All Types</option>
                        <option value="savings" {{ request('account_type') === 'savings' ? 'selected' : '' }}>Savings</option>
                        <option value="checking" {{ request('account_type') === 'checking' ? 'selected' : '' }}>Checking</option>
                        <option value="business" {{ request('account_type') === 'business' ? 'selected' : '' }}>Business</option>
                        <option value="investment" {{ request('account_type') === 'investment' ? 'selected' : '' }}>Investment</option>
                        <option value="fixed_deposit" {{ request('account_type') === 'fixed_deposit' ? 'selected' : '' }}>Fixed Deposit</option>
                    </flux:select>
                </flux:field>

                <!-- Currency -->
                <flux:field>
                    <flux:label>Currency</flux:label>
                    <flux:select name="currency">
                        <option value="">All Currencies</option>
                        <option value="USD" {{ request('currency') === 'USD' ? 'selected' : '' }}>USD</option>
                        <option value="EUR" {{ request('currency') === 'EUR' ? 'selected' : '' }}>EUR</option>
                        <option value="GBP" {{ request('currency') === 'GBP' ? 'selected' : '' }}>GBP</option>
                        <option value="NGN" {{ request('currency') === 'NGN' ? 'selected' : '' }}>NGN</option>
                    </flux:select>
                </flux:field>

                <!-- Verification Status -->
                <flux:field>
                    <flux:label>Verification Status</flux:label>
                    <flux:select name="verification_status">
                        <option value="">All Verification Statuses</option>
                        <option value="pending" {{ request('verification_status') === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="verified" {{ request('verification_status') === 'verified' ? 'selected' : '' }}>Verified</option>
                        <option value="rejected" {{ request('verification_status') === 'rejected' ? 'selected' : '' }}>Rejected</option>
                    </flux:select>
                </flux:field>

                <!-- User -->
                <flux:field>
                    <flux:label>User</flux:label>
                    <flux:select name="user_id">
                        <option value="">All Users</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                {{ $user->name }} ({{ $user->email }})
                            </option>
                        @endforeach
                    </flux:select>
                </flux:field>

                <!-- Master Account -->
                <flux:field>
                    <flux:label>Master Account</flux:label>
                    <flux:select name="is_master_account">
                        <option value="">All Accounts</option>
                        <option value="1" {{ request('is_master_account') === '1' ? 'selected' : '' }}>Master Accounts</option>
                        <option value="0" {{ request('is_master_account') === '0' ? 'selected' : '' }}>Regular Accounts</option>
                    </flux:select>
                </flux:field>

                <!-- Date From -->
                <flux:field>
                    <flux:label>Date From</flux:label>
                    <flux:date-picker 
                        name="date_from" 
                        value="{{ request('date_from') }}"
                    />
                </flux:field>

                <!-- Date To -->
                <flux:field>
                    <flux:label>Date To</flux:label>
                    <flux:date-picker 
                        name="date_to" 
                        value="{{ request('date_to') }}"
                    />
                </flux:field>

                <!-- Sort By -->
                <flux:field>
                    <flux:label>Sort By</flux:label>
                    <flux:select name="sort_by">
                        <option value="created_at" {{ request('sort_by') === 'created_at' ? 'selected' : '' }}>Created Date</option>
                        <option value="account_number" {{ request('sort_by') === 'account_number' ? 'selected' : '' }}>Account Number</option>
                        <option value="account_name" {{ request('sort_by') === 'account_name' ? 'selected' : '' }}>Account Name</option>
                        <option value="balance" {{ request('sort_by') === 'balance' ? 'selected' : '' }}>Balance</option>
                        <option value="status" {{ request('sort_by') === 'status' ? 'selected' : '' }}>Status</option>
                        <option value="account_type" {{ request('sort_by') === 'account_type' ? 'selected' : '' }}>Account Type</option>
                    </flux:select>
                </flux:field>

                <!-- Sort Direction -->
                <flux:field>
                    <flux:label>Sort Direction</flux:label>
                    <flux:select name="sort_direction">
                        <option value="desc" {{ request('sort_direction') === 'desc' ? 'selected' : '' }}>Descending</option>
                        <option value="asc" {{ request('sort_direction') === 'asc' ? 'selected' : '' }}>Ascending</option>
                    </flux:select>
                </flux:field>

                <!-- Filter Buttons -->
                <div class="flex gap-2">
                    <flux:button icon="magnifying-glass" type="submit" variant="primary">
                        Filter
                    </flux:button>
                    <flux:button icon="x-mark" href="{{ route('admin.accounts.index') }}" variant="outline">
                        Clear
                    </flux:button>
                </div>
            </form>
        </div>

        <!-- Accounts Table -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Account
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                User
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Type
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Balance
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Status
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Verification
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Created
                            </th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($accounts as $account)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div>
                                            <div class="text-sm font-medium text-gray-900">
                                                {{ $account->account_number }}
                                            </div>
                                            <div class="text-sm text-gray-500">
                                                {{ $account->account_name }}
                                            </div>
                                            @if($account->is_master_account)
                                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                                    Master Account
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">
                                        {{ $account->user->name }}
                                    </div>
                                    <div class="text-sm text-gray-500">
                                        {{ $account->user->email }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        {{ ucfirst($account->account_type) }}
                                    </span>
                                    <div class="text-sm text-gray-500 mt-1">
                                        {{ $account->currency }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">
                                        {{ $account->currency_symbol }}{{ number_format($account->balance, 2) }}
                                    </div>
                                    <div class="text-sm text-gray-500">
                                        Available: {{ $account->currency_symbol }}{{ number_format($account->available_balance, 2) }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                        @if($account->status === 'active') bg-green-100 text-green-800
                                        @elseif($account->status === 'suspended') bg-red-100 text-red-800
                                        @elseif($account->status === 'frozen') bg-yellow-100 text-yellow-800
                                        @elseif($account->status === 'closed') bg-gray-100 text-gray-800
                                        @else bg-blue-100 text-blue-800
                                        @endif">
                                        {{ $account->account_status_label }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                        @if($account->verification_status === 'verified') bg-green-100 text-green-800
                                        @elseif($account->verification_status === 'rejected') bg-red-100 text-red-800
                                        @else bg-yellow-100 text-yellow-800
                                        @endif">
                                        {{ $account->verification_status_label }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $account->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <div class="flex items-center justify-end space-x-2">
                                        <flux:button 
                                            href="{{ route('admin.accounts.show', $account) }}" 
                                            variant="outline" 
                                            size="sm"
                                        >
                                            <flux:icon name="eye" class="w-4 h-4" />
                                        </flux:button>
                                        <flux:button 
                                            href="{{ route('admin.accounts.edit', $account) }}" 
                                            variant="outline" 
                                            size="sm"
                                        >
                                            <flux:icon name="pencil" class="w-4 h-4" />
                                        </flux:button>
                                        
                                        @if($account->status === 'active')
                                            <form method="POST" action="{{ route('admin.accounts.suspend', $account) }}" class="inline">
                                                @csrf
                                                <flux:button type="submit" variant="outline" size="sm" class="text-yellow-600 hover:text-yellow-700">
                                                    <flux:icon name="pause" class="w-4 h-4" />
                                                </flux:button>
                                            </form>
                                        @elseif($account->status === 'suspended')
                                            <form method="POST" action="{{ route('admin.accounts.activate', $account) }}" class="inline">
                                                @csrf
                                                <flux:button type="submit" variant="outline" size="sm" class="text-green-600 hover:text-green-700">
                                                    <flux:icon name="play" class="w-4 h-4" />
                                                </flux:button>
                                            </form>
                                        @endif

                                        @if($account->status !== 'closed')
                                            <form method="POST" action="{{ route('admin.accounts.close', $account) }}" class="inline">
                                                @csrf
                                                <flux:button type="submit" variant="outline" size="sm" class="text-red-600 hover:text-red-700">
                                                    <flux:icon name="x-mark" class="w-4 h-4" />
                                                </flux:button>
                                            </form>
                                        @endif

                                        <!-- Credit/Debit Account Button -->
                                        <flux:modal.trigger name="credit-debit-modal-{{ $account->id }}">
                                            <flux:button 
                                                variant="outline" 
                                                size="sm"
                                                class="text-blue-600 hover:text-blue-700"
                                                title="Credit/Debit Account"
                                            >
                                                <flux:icon name="currency-dollar" class="w-4 h-4" />
                                            </flux:button>
                                        </flux:modal.trigger>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="px-6 py-12 text-center">
                                    <div class="text-gray-500">
                                        <flux:icon name="inbox" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                                        <p class="text-lg font-medium">No accounts found</p>
                                        <p class="text-sm">Try adjusting your search criteria or create a new account.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($accounts->hasPages())
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $accounts->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- Credit/Debit Modals -->
    @foreach($accounts as $account)
        <flux:modal name="credit-debit-modal-{{ $account->id }}" title="Credit/Debit Account" class="md:w-128">
            <div class="space-y-6">
                <!-- Account Info -->
                <div class="bg-gray-50 rounded-lg p-4">
                    <h3 class="text-lg font-medium text-gray-900">{{ $account->account_name }}</h3>
                    <p class="text-sm text-gray-600">Account: {{ $account->account_number }}</p>
                    <p class="text-sm text-gray-600">Current Balance: {{ $account->currency_symbol }}{{ number_format($account->balance, 2) }}</p>
                </div>

                <!-- Transaction Form -->
                <form method="POST" action="{{ route('admin.accounts.transaction', $account) }}" class="space-y-4">
                    @csrf
                    
                    <!-- Transaction Type -->
                    <flux:field>
                        <flux:label>Transaction Type</flux:label>
                        <flux:select name="type" required>
                            <option value="">Select Type</option>
                            <option value="credit">Credit (Add Money)</option>
                            <option value="debit">Debit (Remove Money)</option>
                        </flux:select>
                    </flux:field>

                    <!-- Amount -->
                    <flux:field>
                        <flux:label>Amount ({{ $account->currency }})</flux:label>
                        <flux:input 
                            type="number" 
                            name="amount" 
                            step="0.01" 
                            min="0.01" 
                            placeholder="0.00"
                            required
                        />
                    </flux:field>

                    <!-- Create Transaction Checkbox -->
                    <flux:field>
                        <flux:checkbox 
                            name="create_transaction" 
                            value="1"
                        />
                        <flux:label>Create Transaction Record</flux:label>
                        <flux:description>Check this to create a formal transaction record in the system</flux:description>
                    </flux:field>
                    <!-- Submit Buttons -->
                    <div class="flex justify-end space-x-3 pt-4">
                        <flux:button type="button" variant="outline" @click="$dispatch('close-modal', 'credit-debit-modal-{{ $account->id }}')">
                            Cancel
                        </flux:button>
                        <flux:button type="submit" variant="primary">
                            Process Transaction
                        </flux:button>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endforeach
@endsection
