<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class BankingRolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions for different banking operations
        $permissions = [
            // User Management
            'view-users',
            'create-users',
            'edit-users',
            'delete-users',
            'view-user-details',
            
            // Account Management
            'view-accounts',
            'create-accounts',
            'edit-accounts',
            'delete-accounts',
            'view-account-details',
            'freeze-accounts',
            'unfreeze-accounts',
            
            // Transaction Management
            'view-transactions',
            'create-transactions',
            'edit-transactions',
            'delete-transactions',
            'approve-transactions',
            'reject-transactions',
            'view-transaction-details',
            
            // Transfer Management
            'view-transfers',
            'create-transfers',
            'edit-transfers',
            'delete-transfers',
            'approve-transfers',
            'reject-transfers',
            'view-transfer-details',
            
            // Deposit Management
            'view-deposits',
            'create-deposits',
            'edit-deposits',
            'delete-deposits',
            'approve-deposits',
            'reject-deposits',
            'view-deposit-details',
            
            // Withdrawal Management
            'view-withdrawals',
            'create-withdrawals',
            'edit-withdrawals',
            'delete-withdrawals',
            'approve-withdrawals',
            'reject-withdrawals',
            'view-withdrawal-details',
            
            // KYC Management
            'view-kyc',
            'create-kyc',
            'edit-kyc',
            'delete-kyc',
            'approve-kyc',
            'reject-kyc',
            'view-kyc-details',
            
            // Reports and Analytics
            'view-reports',
            'create-reports',
            'export-reports',
            'view-analytics',
            'view-dashboard',
            
            // System Settings
            'view-settings',
            'edit-settings',
            'view-system-logs',
            'view-audit-logs',
            'view-activity-logs',
            
            // Customer Operations
            'view-own-account',
            'view-own-transactions',
            'create-own-transfers',
            'view-own-kyc',
            'update-own-profile',
            
            // Admin Operations
            'manage-roles',
            'manage-permissions',
            'assign-roles',
            'view-admin-panel',
            'access-bank-operations',
        ];

        // Create permissions
        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create Super Admin role with all permissions
        $superAdminRole = Role::create(['name' => 'super-admin']);
        $superAdminRole->givePermissionTo(Permission::all());

        // Create Admin role with bank operations permissions
        $adminRole = Role::create(['name' => 'admin']);
        $adminRole->givePermissionTo([
            // User Management (limited)
            'view-users',
            'view-user-details',
            
            // Account Management
            'view-accounts',
            'edit-accounts',
            'view-account-details',
            'freeze-accounts',
            'unfreeze-accounts',
            
            // Transaction Management
            'view-transactions',
            'edit-transactions',
            'approve-transactions',
            'reject-transactions',
            'view-transaction-details',
            
            // Transfer Management
            'view-transfers',
            'edit-transfers',
            'approve-transfers',
            'reject-transfers',
            'view-transfer-details',
            
            // Deposit Management
            'view-deposits',
            'edit-deposits',
            'approve-deposits',
            'reject-deposits',
            'view-deposit-details',
            
            // Withdrawal Management
            'view-withdrawals',
            'edit-withdrawals',
            'approve-withdrawals',
            'reject-withdrawals',
            'view-withdrawal-details',
            
            // KYC Management
            'view-kyc',
            'edit-kyc',
            'approve-kyc',
            'reject-kyc',
            'view-kyc-details',
            
            // Reports and Analytics
            'view-reports',
            'export-reports',
            'view-analytics',
            'view-dashboard',
            
            // System Settings (limited)
            'view-settings',
            'view-system-logs',
            'view-audit-logs',
            'view-activity-logs',
            
            // Admin Operations
            'view-admin-panel',
            'access-bank-operations',
        ]);

        // Create Customer role with limited permissions
        $customerRole = Role::create(['name' => 'customer']);
        $customerRole->givePermissionTo([
            // Customer Operations
            'view-own-account',
            'view-own-transactions',
            'create-own-transfers',
            'view-own-kyc',
            'update-own-profile',
        ]);

        $this->command->info('Banking roles and permissions created successfully!');
        $this->command->info('Roles created: super-admin, admin, customer');
    }
}
