<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Email verification code
            $table->string('email_verification_code')->nullable();
            $table->timestamp('email_verification_code_expires_at')->nullable();
            $table->integer('email_verification_attempts')->default(0);
            $table->timestamp('last_email_verification_attempt')->nullable();
            
            // Password reset code
            $table->string('password_reset_code')->nullable();
            $table->timestamp('password_reset_code_expires_at')->nullable();
            $table->integer('password_reset_attempts')->default(0);
            $table->timestamp('last_password_reset_attempt')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'email_verification_code',
                'email_verification_code_expires_at',
                'email_verification_attempts',
                'last_email_verification_attempt',
                'password_reset_code',
                'password_reset_code_expires_at',
                'password_reset_attempts',
                'last_password_reset_attempt'
            ]);
        });
    }
};
