<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('compliance_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('account_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('transaction_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('kyc_document_id')->nullable()->constrained()->onDelete('set null');
            $table->string('type'); // 'transaction_flag', 'kyc_review', 'risk_assessment', 'compliance_check'
            $table->string('category'); // 'suspicious_activity', 'high_value_transaction', 'unusual_pattern', 'document_verification'
            $table->string('severity'); // 'low', 'medium', 'high', 'critical'
            $table->string('status')->default('pending'); // 'pending', 'under_review', 'approved', 'rejected', 'escalated'
            $table->text('description');
            $table->text('details')->nullable(); // JSON field for additional data
            $table->text('admin_notes')->nullable();
            $table->foreignId('reviewed_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('reviewed_at')->nullable();
            $table->text('resolution_notes')->nullable();
            $table->string('resolution_status')->nullable(); // 'resolved', 'false_positive', 'requires_action'
            $table->json('risk_factors')->nullable(); // Array of risk factors
            $table->decimal('amount', 15, 2)->nullable(); // Transaction amount if applicable
            $table->string('currency', 3)->nullable();
            $table->string('source_ip')->nullable();
            $table->string('user_agent')->nullable();
            $table->json('metadata')->nullable(); // Additional metadata
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['type', 'status']);
            $table->index(['severity', 'status']);
            $table->index(['user_id', 'created_at']);
            $table->index(['reviewed_by', 'reviewed_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('compliance_logs');
    }
};
