<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kyc_documents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('document_type'); // 'id', 'passport', 'utility_bill', 'bank_statement', 'proof_of_address'
            $table->string('document_name');
            $table->string('file_path');
            $table->string('file_name');
            $table->string('mime_type');
            $table->bigInteger('file_size');
            $table->string('status')->default('pending'); // 'pending', 'approved', 'rejected', 'expired'
            $table->text('rejection_reason')->nullable();
            $table->foreignId('reviewed_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('reviewed_at')->nullable();
            $table->text('review_notes')->nullable();
            $table->json('metadata')->nullable(); // Additional document metadata
            $table->timestamp('expires_at')->nullable(); // Document expiration date
            $table->boolean('is_primary')->default(false); // Primary document for this type
            $table->string('verification_level')->default('basic'); // 'basic', 'enhanced', 'full'
            $table->timestamps();
            
            // Indexes
            $table->index(['user_id', 'document_type']);
            $table->index(['status', 'reviewed_at']);
            $table->index('expires_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kyc_documents');
    }
};
