<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('virtual_cards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('account_id')->constrained()->onDelete('cascade');
            
            // Basic Card Information
            $table->string('card_number')->unique(); // Virtual card number (masked)
            $table->string('card_type'); // debit, credit, prepaid
            $table->string('card_brand'); // visa, mastercard, amex
            $table->string('card_name')->nullable(); // User-defined card name
            
            // Essential Details
            $table->string('cvv')->nullable(); // CVV code (encrypted)
            $table->date('expiry_date');
            $table->string('currency', 3); // Card currency
            $table->decimal('credit_limit', 20, 4)->nullable(); // For credit cards
            $table->decimal('current_balance', 20, 4)->default(0);
            
            // Simple Status
            $table->enum('status', ['active', 'inactive', 'blocked'])->default('active');
            $table->timestamp('activated_at')->nullable();
            
            // Basic Controls
            $table->decimal('daily_limit', 20, 4)->nullable();
            $table->decimal('monthly_limit', 20, 4)->nullable();
            
            // Simple Features
            $table->boolean('online_payments')->default(true);
            $table->boolean('atm_withdrawals')->default(true);
            $table->boolean('international_usage')->default(false);
            
            // Basic Usage Tracking
            $table->integer('total_transactions')->default(0);
            $table->decimal('total_spent', 20, 4)->default(0);
            $table->timestamp('last_used_at')->nullable();
            
            // Timestamps
            $table->timestamps();
            $table->softDeletes();
            
            // Essential Indexes
            $table->index(['user_id']);
            $table->index(['account_id']);
            $table->index(['card_number']);
            $table->index(['status']);
            $table->index(['expiry_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('virtual_cards');
    }
};
