<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Financial Profile
            $table->string('customer_id', 8)->unique()->after('email'); // Bank's internal customer ID (8-digit)
            $table->enum('customer_type', ['individual', 'business', 'corporate', 'premium'])->default('individual')->after('customer_id');
            $table->string('pin', 8)->after('customer_type'); // 6-8 digit PIN for banking operations
            $table->enum('customer_status', ['active', 'inactive', 'suspended', 'pending_verification', 'closed'])->default('pending_verification')->after('customer_type');
            

            
            // Activity Tracking (Core user activity)
            $table->timestamp('account_activated_at')->nullable()->after('customer_status');
            $table->timestamp('last_login_at')->nullable()->after('account_activated_at');
            $table->timestamp('last_activity_at')->nullable()->after('last_login_at');
            
            // Indexes for performance
            $table->index(['customer_id']);
            $table->index(['customer_type']);
            $table->index(['customer_status']);
            $table->index(['last_activity_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropIndex(['customer_id']);
            $table->dropIndex(['customer_type']);
            $table->dropIndex(['customer_status']);
            $table->dropIndex(['last_activity_at']);
            
            $table->dropColumn([
                'customer_id',
                'customer_type',
                'pin',
                'customer_status',
                'account_activated_at',
                'last_login_at',
                'last_activity_at'
            ]);
        });
    }
};
