<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // Personal Information
            $table->string('first_name');
            $table->string('last_name');
            $table->string('middle_name')->nullable();
            $table->date('date_of_birth');
            $table->enum('gender', ['male', 'female', 'other', 'prefer_not_to_say']);
            $table->enum('marital_status', ['single', 'married', 'divorced', 'widowed', 'separated']);
            $table->string('city');
            $table->text('address_line_1');
            $table->string('postal_code');
            $table->string('state_province')->nullable();
            $table->string('country');
            $table->string('phone_number');
            
            // Emergency Contact
            $table->string('emergency_contact_name')->nullable();
            $table->string('emergency_contact_phone')->nullable();
            $table->string('emergency_contact_relationship')->nullable();
            
            // Additional Information
            $table->string('occupation');
            $table->decimal('annual_income', 15, 2)->nullable();
            $table->string('preferred_language', 5)->default('en');
            $table->string('timezone')->default('UTC');
            
            // KYC Information
            $table->enum('kyc_status', ['pending', 'verified', 'rejected', 'under_review'])->default('pending');
            $table->timestamp('kyc_verified_at')->nullable();
            $table->enum('aml_status', ['pending', 'clear', 'flagged', 'blocked'])->default('pending');
            $table->enum('compliance_status', ['compliant', 'non_compliant', 'pending_review', 'under_investigation'])->default('pending_review');
            
            // Additional
            $table->text('notes')->nullable();
            $table->json('metadata')->nullable();
            
            // Timestamps
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index(['user_id']);
            $table->index(['kyc_status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_profiles');
    }
};
