<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PasswordChangedNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Password Changed - ' . \App\Helpers\SettingsHelper::bankName())
            ->greeting('Hello ' . $notifiable->name . '!')
            ->line('Your password has been successfully changed.')
            ->line('**Change Details:**')
            ->line('• **Time:** ' . now()->format('F j, Y \a\t g:i A T'))
            ->line('• **IP Address:** ' . request()->ip())
            ->line('• **User Agent:** ' . request()->userAgent())
            ->line('If you did not make this change, please contact our support team immediately.')
            ->action('Contact Support', 'mailto:' . \App\Helpers\SettingsHelper::supportEmail())
            ->line('For your security, we recommend:')
            ->line('• Using a strong, unique password')
            ->line('• Enabling two-factor authentication')
            ->line('• Regularly updating your password')
            ->line('• Never sharing your password with anyone')
            ->salutation('Best regards, The ' . \App\Helpers\SettingsHelper::bankName() . ' Security Team');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'password_changed',
            'message' => 'Your password has been successfully changed.',
            'timestamp' => now(),
        ];
    }
}
