<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Code extends Model
{
    protected $fillable = [
        'user_id',
        'cot_code',
        'cot_status',
        'cot_msg',
        'tax_code',
        'tax_status',
        'tax_msg',
        'imf_code',
        'imf_status',
        'imf_msg',
        'allow_local',
        'allow_international',
    ];

    protected $casts = [
        'cot_status' => 'boolean',
        'tax_status' => 'boolean',
        'imf_status' => 'boolean',
        'allow_local' => 'boolean',
        'allow_international' => 'boolean',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
