<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TwoFactorVerificationMail extends Mailable
{
    use Queueable, SerializesModels;

    public string $verificationCode;
    public string $userName;
    public string $expiresAt;

    /**
     * Create a new message instance.
     */
    public function __construct(string $verificationCode, string $userName, string $expiresAt)
    {
        $this->verificationCode = $verificationCode;
        $this->userName = $userName;
        $this->expiresAt = $expiresAt;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Two-Factor Authentication Code - ' . \App\Helpers\SettingsHelper::bankName(),
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.two-factor-verification',
            with: [
                'verificationCode' => $this->verificationCode,
                'userName' => $this->userName,
                'expiresAt' => $this->expiresAt,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
