<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\User;

class TwoFactorCodeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $code;
    public $user;
    public $transfer;

    /**
     * Create a new message instance.
     */
    public function __construct(string $code, User $user, array $transfer)
    {
        $this->code = $code;
        $this->user = $user;
        $this->transfer = $transfer;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Two-Factor Authentication Code - ' . \App\Helpers\SettingsHelper::bankName(),
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.two-factor-code',
            with: [
                'code' => $this->code,
                'user' => $this->user,
                'transfer' => $this->transfer,
                'bankName' => \App\Helpers\SettingsHelper::bankName(),
                'bankLogo' => \App\Helpers\SettingsHelper::bankLogo(),
            ]
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
